<?php $__env->startSection('title', __('lang.contact')); ?>
<?php $__env->startSection('keywords', __('seo_lang.contact_kw')); ?>
<?php $__env->startSection('content'); ?>
<!-- Begin bread crumbs -->
<nav class="bread-crumbs">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <ul class="bread-crumbs-list">
                    <li>
                        <a href="<?php echo e(url($dataFromBaseController['language'] . '/home')); ?>"><?php echo e(__('lang.home')); ?></a>
                        <i class="material-icons md-18">chevron_right</i>
                    </li>
                    <li><a href="<?php echo e(url($dataFromBaseController['language'] . '/contact-us')); ?>"><?php echo e(__('lang.contact')); ?></a>
                    </li>
                </ul>
            </div>
        </div>
    </div>
</nav>
<!-- End bread crumbs -->

<!-- Begin Content -->
<div class="section">
    <?php $__currentLoopData = $dataFromBaseController['contacts']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $contact): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <div class="container">
        <div class="col-12">
            <div class="home-heading section-heading heading-center">
                <span><?php echo e($contact->{$dataFromBaseController['language'] . '_title'}); ?></span>
                <p><?php echo e($contact->{$dataFromBaseController['language'] . '_subtitle'}); ?></p>
            </div>
        </div>
    </div>

    <div class="container form-heading-center">
        <div class="row content-items d-flex justify-content-center text-center">
            <div class="col-md-4 col-12 content-item">
                <div class="contacts-info-item item-style">
                    <div class="contacts-info-item-ico">
                        <i class="material-icons md-60">location_on</i>
                    </div>
                    <div class="contacts-info-item-content">
                        <a href="https://www.google.com/maps/place/4730+Crystal+Springs+Dr,+Los+Angeles,+CA+90027,+%D0%A1%D0%A8%D0%90/data=!4m2!3m1!1s0x80c2c08ea296b841:0x5030fc6064b8e8d1?sa=X&ved=2ahUKEwijmtvUqZvjAhXjkIsKHYNsDswQ8gEwAHoECAkQAQ">
                            <?php echo e($contact->{$dataFromBaseController['language'] . '_address'}); ?>

                        </a>
                        <p><?php echo e($contact->{$dataFromBaseController['language'] . '_subtitle_address'}); ?></p>
                    </div>
                </div>
            </div>
            <div class="col-md-4 col-12 content-item">
                <div class="contacts-info-item item-style">
                    <div class="contacts-info-item-ico">
                        <i class="material-icons md-60 footer-contact-email">email</i>
                    </div>
                    <div class="contacts-info-item-content">
                        <div>
                            <a href="<?php echo e($contact->first_email); ?>"><?php echo e($contact->first_email); ?></a>
                        </div>
                        <div>
                            <a href="<?php echo e($contact->second_email); ?>"><?php echo e($contact->second_email); ?></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</div>
<!-- End Content -->
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\spacetoon_originals\resources\views/contact_us.blade.php ENDPATH**/ ?>