<!DOCTYPE html>
<html lang="en">

<head>

    <meta charset="utf-8">

    <title> <?php echo $__env->yieldContent('title'); ?> | <?php echo e(__('lang.title')); ?></title>

    <meta name="keywords" content="<?php echo $__env->yieldContent('keywords'); ?>">
    <meta name="description" content="<?php echo $__env->yieldContent('description'); ?>">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=2">

    <link rel="icon" href="<?php echo e(URL::asset('assets/img/spacetoon_original_logo.png')); ?>" type="image/x-icon">

    <link rel="stylesheet" href="<?php echo e(URL::asset('assets/css/libs.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(URL::asset('assets/css/style.css')); ?>">
    <?php if(app()->getLocale() == 'ar'): ?>
    <link rel="stylesheet" href="<?php echo e(URL::asset('assets/css/libs-rtl.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(URL::asset('assets/css/style-rtl.css')); ?>">
    <?php endif; ?>

    <link href='https://fonts.googleapis.com/css?family=Tajawal' rel='stylesheet'>

    <link rel="preload" href="<?php echo e(URL::asset('assets/fonts/istok-web-v15-latin/istok-web-v15-latin-regular.woff2')); ?>" as="font" type="font/woff2" crossorigin>
    <link rel="preload" href="<?php echo e(URL::asset('assets/fonts/istok-web-v15-latin/istok-web-v15-latin-700.woff2')); ?>" as="font" type="font/woff2" crossorigin>
    <link rel="preload" href="<?php echo e(URL::asset('assets/fonts/montserrat-v15-latin/montserrat-v15-latin-700.woff2')); ?>" as="font" type="font/woff2" crossorigin>
    <link rel="preload" href="<?php echo e(URL::asset('assets/fonts/montserrat-v15-latin/montserrat-v15-latin-600.woff2')); ?>" as="font" type="font/woff2" crossorigin>

    <link rel="preload" href="<?php echo e(URL::asset('assets/fonts/material-icons/material-icons.woff2')); ?>" as="font" type="font/woff2" crossorigin>
    <link rel="preload" href="<?php echo e(URL::asset('assets/fonts/material-icons/material-icons-outlined.woff2')); ?>" as="font" type="font/woff2" crossorigin>

</head>

<body>
    <main class="main">
        <div class="main-inner">
            
            <nav class="mob-main-mnu">
                <div class="mob-main-mnu-content">
                    <ul class="mob-main-mnu-list">
                        
                        <li>
                            <a href="<?php echo e(url($dataFromBaseController['language'] . '/home')); ?>"><?php echo e(__('lang.home')); ?></a>
                        </li>


                        
                        <li>
                            <a href="<?php echo e(url($dataFromBaseController['language'] . '/home/#production')); ?>"><?php echo e(__('lang.production')); ?></a>
                        </li>

                        
                        <li>
                            
                            <a href="<?php echo e(url($dataFromBaseController['language'] . '/channels')); ?>"><?php echo e(__('lang.channels')); ?></a>
                        </li>

                        
                        <li>
                            <a href="<?php echo e(url($dataFromBaseController['language'] . '/contact-us')); ?>"><?php echo e(__('lang.contactUs')); ?></a>
                        </li>
                        
                        <li>
                            <a href="<?php echo e(url($dataFromBaseController['language'] . '/about-us')); ?>"><?php echo e(__('lang.aboutUs')); ?></a>
                        </li>
                    </ul>
                </div>
                <div class="mob-main-mnu-footer">
                    <ul class="mob-main-mnu-lang">
                        <li class=""><a href="<?php echo e(url('locale/en')); ?>"><span>En</span></a></li>
                        <li><a href="<?php echo e(url('locale/ar')); ?>"><span>Ar</span></a></li>
                    </ul>
                </div>
            </nav>
            <!-- End mobile main menu -->

            <!-- Begin header -->
            <header class="header">
                <!-- Begin header fixed -->
                <nav class="header-fixed">
                    <div class="container">
                        <div class="row flex-nowrap align-items-center justify-content-between">
                            <div class="col-auto d-block d-lg-none header-fixed-col">
                                <div class="main-mnu-btn">
                                    <span class="bar bar-1"></span>
                                    <span class="bar bar-2"></span>
                                    <span class="bar bar-3"></span>
                                    <span class="bar bar-4"></span>
                                </div>
                            </div>
                            <div class="col-auto header-fixed-col">
                                <!-- Begin logo -->
                                <a href="<?php echo e(url($dataFromBaseController['language'] . '/home')); ?>" class="logo" title="Business">
                                    <img src="<?php echo e(URL::asset('assets/img/spacetoon_original_logo.png')); ?>" alt="Business">
                                </a>
                                <!-- End logo -->
                            </div>
                            <div class="col-lg col-auto col-static header-fixed-col">
                                <div class="row flex-nowrap align-items-center justify-content-end">
                                    <div class="col-auto header-fixed-col d-none d-lg-block col-static">
                                        <!-- Begin main menu -->
                                        <nav class="main-mnu">
                                            <ul class="main-mnu-list">
                                                
                                                <li class="menu-item-has-children">
                                                    <a href="<?php echo e(url($dataFromBaseController['language'] . '/home')); ?>" data-title="<?php echo e(__('lang.home')); ?>">
                                                        <span><?php echo e(__('lang.home')); ?></span>
                                                    </a>
                                                </li>

                                                
                                                <li class="menu-item-has-children">
                                                    <a href="<?php echo e(url($dataFromBaseController['language'] . '/home/#production')); ?>" data-title="<?php echo e(__('lang.production')); ?>">
                                                        <span><?php echo e(__('lang.production')); ?></span>
                                                    </a>
                                                </li>
                                                
                                                <li class="menu-item-has-children">
                                                    <a href="<?php echo e(url($dataFromBaseController['language'] . '/channels')); ?>" data-title="<?php echo e(__('lang.channels')); ?>">
                                                        <span><?php echo e(__('lang.channels')); ?></span>
                                                    </a>
                                                </li>
                                                
                                                <li class="menu-item-has-children">
                                                    <a href="<?php echo e(url($dataFromBaseController['language'] . '/contact-us')); ?>" data-title="<?php echo e(__('lang.contactUs')); ?>">
                                                        <span><?php echo e(__('lang.contactUs')); ?></span>
                                                    </a>
                                                </li>
                                                
                                                <li class="menu-item-has-children">
                                                    <a href="<?php echo e(url($dataFromBaseController['language'] . '/about-us')); ?>" data-title="<?php echo e(__('lang.aboutUs')); ?>">
                                                        <span><?php echo e(__('lang.aboutUs')); ?></span>
                                                    </a>
                                                </li>
                                            </ul>
                                        </nav>
                                        <!-- End main menu -->
                                    </div>
                                    <div class="col-auto header-fixed-col col-static">
                                        <!-- Begin header actions -->
                                        <ul class="header-actions">
                                            <!-- Begin header languarge -->
                                            <li class="d-none d-lg-block">
                                                <div class="header-lang">
                                                    <div class="header-lang-current"><i class="material-icons md-22">language</i></div>
                                                    <ul class="header-lang-list">
                                                        <li><a href="<?php echo e(url('locale/en')); ?>" class="hover-link" data-lang="En" data-title="<?php echo e(__('lang.english')); ?>"><span><?php echo e(__('lang.english')); ?></span></a>
                                                        </li>
                                                        <li><a href="<?php echo e(url('locale/ar')); ?>" class="hover-link" data-lang="Ar" data-title="<?php echo e(__('lang.arabic')); ?>"><span><?php echo e(__('lang.arabic')); ?></span></a>
                                                        </li>
                                                    </ul>
                                                </div>
                                            </li>
                                            <!-- End header languarge -->
                                        </ul>
                                        <!-- End header actions -->
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </nav>
                <!-- End header fixed -->
            </header>
            <!-- End header -->
            <?php echo $__env->yieldContent('content'); ?>
        </div>
        <!-- Begin footer -->
        <footer class="footer">
            <?php $__currentLoopData = $dataFromBaseController['contacts']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $contact): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <ul class="footer-social-links">
                <li>
                    <a target="_blank" href=<?php echo e($contact->linkedIn); ?> title="LinkedIn">
                        <svg viewBox="0 0 448 512">
                            <use class="icon-svg" xlink:href="<?php echo e(URL::asset('assets/img/sprite.svg#linkedin-icon')); ?>">
                            </use>
                        </svg>
                    </a>
                </li>
                <li>
                    <a target="_blank" href=<?php echo e($contact->facebook); ?> title="Facebook">
                        <svg viewBox="0 0 320 512">
                            <use class="icon-svg" xlink:href="<?php echo e(URL::asset('assets/img/sprite.svg#facebook-icon')); ?>">
                            </use>
                        </svg>
                    </a>
                </li>
                <li>
                    <a target="_blank" href=<?php echo e($contact->youtube); ?> title="YouTube">
                        <svg viewBox="0 0 512 512">
                            <use class="icon-svg" xlink:href="<?php echo e(URL::asset('assets/img/sprite.svg#youtube-icon')); ?>">
                            </use>
                        </svg>
                    </a>
                </li>
                <li>
                    <a target="_blank" href=<?php echo e($contact->instagram); ?> title="Instagram">
                        <svg viewBox="0 0 448 512">
                            <use class="icon-svg" xlink:href="<?php echo e(URL::asset('assets/img/sprite.svg#instagram-icon')); ?>">
                            </use>
                        </svg>
                    </a>
                </li>
            </ul>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <div class="col-md-auto col-12 item">
                <div class="copyright">
                    <?php echo e(__('lang.title')); ?> <?php echo e(date('Y')); ?> | <?php echo e(__('lang.rights')); ?>

                </div>
            </div>
        </footer>
        <!-- End footer -->
    </main>

    <script src="<?php echo e(URL::asset('assets/libs/jquery/jquery.min.js')); ?>"></script>
    <script src="<?php echo e(URL::asset('assets/libs/lozad/lozad.min.js')); ?>"></script>
    <script src="<?php echo e(URL::asset('assets/libs/device/device.js')); ?>"></script>
    <script src="<?php echo e(URL::asset('assets/libs/ScrollToFixed/jquery-scrolltofixed-min.js')); ?>"></script>
    <script src="<?php echo e(URL::asset('assets/libs/spincrement/jquery.spincrement.min.js')); ?>"></script>
    <script src="<?php echo e(URL::asset('assets/libs/jquery-popup-overlay-gh-pages/jquery.popupoverlay.js')); ?>"></script>
    <script src="<?php echo e(URL::asset('assets/libs/jquery-validation-1.19.3/jquery.validate.min.js')); ?>"></script>
    <script src="<?php echo e(URL::asset('assets/libs/autosize-master/autosize.min.js')); ?>"></script>
    <script src="<?php echo e(URL::asset('assets/libs/flickity/flickity.pkgd.min.js')); ?>"></script>
    <script src="<?php echo e(URL::asset('assets/libs/flickity/flickity-imagesloaded.js')); ?>"></script>
    <script src="<?php echo e(URL::asset('assets/libs/flickity/bg-lazyload.js')); ?>"></script>
    <script src="<?php echo e(URL::asset('assets/libs/flickity/flickity-fade.js')); ?>"></script>
    <script src="<?php echo e(URL::asset('assets/libs/isotope/isotope.pkgd.min.js')); ?>"></script>
    <script src="<?php echo e(URL::asset('assets/libs/lightGallery/js/picturefill.min.js')); ?>"></script>
    <script src="<?php echo e(URL::asset('assets/libs/lightGallery/js/lightgallery-all.min.js')); ?>"></script>
    <script src="<?php echo e(URL::asset('assets/libs/lightGallery/js/jquery.mousewheel.min.js')); ?>"></script>
    <script src="<?php echo e(URL::asset('assets/libs/jquery-ui-range/jquery-ui.min.js')); ?>"></script>
    <script src="<?php echo e(URL::asset('assets/js/custom.js')); ?>"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
    

    
</body>

</html><?php /**PATH /home/stgnet/public_html/ni321/spacetoon_originals/resources/views/layout.blade.php ENDPATH**/ ?>