<?php

use App\Http\Controllers\ChannelController;
use App\Http\Controllers\ContactController;
use App\Http\Controllers\InfoController;
use App\Http\Controllers\PosterController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\LocalizationController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::group(['prefix' => 'admin'], function () {
    Voyager::routes();
});

Route::group(['prefix' => '{locale}'], function () {
    Route::get('home', [HomeController::class, 'home']);
    Route::get('contact-us', [ContactController::class, 'contact']);
    Route::get('channels', [ChannelController::class, 'channel']);
    Route::get('about-us', [InfoController::class, 'info']);
});

Route::get('poster/{slug}', [PosterController::class, 'show']);
Route::get('{locale}', [HomeController::class, 'home']);
Route::get('/', [HomeController::class, 'home']);
Route::get("locale/{lange}", [LocalizationController::class, 'setLang']);
