@extends('layout')

@section('title', $details->{$dataFromBaseController['language'] . '_title'})
{{-- @section('keywords', $SEO['keyWords'] ?? $SEO['title'])
@section('description', $SEO['description']) --}}
@section('content')

    <main class="main">
        <!-- Begin bread crumbs -->
        <nav class="bread-crumbs">
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <ul class="bread-crumbs-list">
                            <li><a
                                    href="{{ url($dataFromBaseController['language'] . '/home') }}">{{ __('lang.home') }}</a><i
                                    class="material-icons md-18">chevron_right</i></li>

                            <li><a href="#!">{{ $details->{$dataFromBaseController['language'] . '_title'} }}</a></li>
                        </ul>
                    </div>
                </div>
            </div>
        </nav>
        <!-- End bread crumbs -->

        <!-- Begin Content -->
        <div class="section">
            <div class="container">
                <div class="row content-items">
                    <div class="col-12 content-item">
                        <div class="news-post">
                            <header class="news-post-header text-center">
                                <div class="news-post-img">
                                    <iframe src="{{ $details->poster_video }}?autoplay=1&mute=0" allow="autoplay; ">
                                    </iframe>
                                </div>
                            </header>
                            <div class="col-12 post">
                                <h1 class="news-post-title">
                                    {{ $details->{$dataFromBaseController['language'] . '_title'} }}
                                </h1>
                                <span class="news-post-subtitle">
                                    {{ $details->{$dataFromBaseController['language'] . '_subtitle'} }}
                                </span>
                                <p>{!! $details->{$dataFromBaseController['language'] . '_bref'} !!}</p>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
            <div class="row details_info_poster">
                <div class="container">
                    <div class="col-12">
                        <span>{{ __('lang.productionYear') }}:</span>
                         {{ $details->{$dataFromBaseController['language'] . '_production_year'} }}
                    </div>
                    <div class="col-12">
                        <span>{{ __('lang.productionType') }}:</span> {{ $details->production_type }}
                    </div>
                    <div class="col-12">
                        <span>{{ __('lang.numberOfSeasons') }}:</span> {{ $details->number_of_seasons }}
                    </div>
                    <div class="col-12">
                        <span>{{ __('lang.numberOfEpisodes') }}:</span> {{ $details->number_of_episodes_seasons }}
                    </div>
                    <div class="col-12">
                        <span>{{ __('lang.episodeDuration') }}:</span>
                        {{ $details->{$dataFromBaseController['language'] . '_episode_duration'} }}
                    </div>
                    <div class="col-12">
                        <span>{{ __('lang.partneringWith') }}:</span>
                        {{ $details->{$dataFromBaseController['language'] . '_partnering'} }}
                    </div>
                    <div class="col-12">
                        <span>{{ __('lang.ageGroup') }}:</span>
                        {{ $details->{$dataFromBaseController['language'] . '_age_group'} }}
                    </div>
                    <div class="button_poster col-12 d-flex justify-content-center">
                        <a href="{{ url($dataFromBaseController['language'] . '/contact-us') }}">
                            {{ __('lang.contactUsNow') }}
                        </a>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Content -->
    </main>
@endsection
