<!DOCTYPE html>
<html lang="en">

<head>

    <meta charset="utf-8">

    <title> @yield('title') | {{ __('lang.title') }}</title>

    <meta name="keywords" content="@yield('keywords')">
    <meta name="description" content="@yield('description')">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=2">

    <link rel="icon" href="{{ URL::asset('assets/img/spacetoon_original_logo.png') }}" type="image/x-icon">

    <link rel="stylesheet" href="{{ URL::asset('assets/css/libs.css') }}">
    <link rel="stylesheet" href="{{ URL::asset('assets/css/style.css') }}">
    @if (app()->getLocale() == 'ar')
    <link rel="stylesheet" href="{{ URL::asset('assets/css/libs-rtl.css') }}">
    <link rel="stylesheet" href="{{ URL::asset('assets/css/style-rtl.css') }}">
    @endif

    <link href='https://fonts.googleapis.com/css?family=Tajawal' rel='stylesheet'>

    <link rel="preload" href="{{ URL::asset('assets/fonts/istok-web-v15-latin/istok-web-v15-latin-regular.woff2') }}" as="font" type="font/woff2" crossorigin>
    <link rel="preload" href="{{ URL::asset('assets/fonts/istok-web-v15-latin/istok-web-v15-latin-700.woff2') }}" as="font" type="font/woff2" crossorigin>
    <link rel="preload" href="{{ URL::asset('assets/fonts/montserrat-v15-latin/montserrat-v15-latin-700.woff2') }}" as="font" type="font/woff2" crossorigin>
    <link rel="preload" href="{{ URL::asset('assets/fonts/montserrat-v15-latin/montserrat-v15-latin-600.woff2') }}" as="font" type="font/woff2" crossorigin>

    <link rel="preload" href="{{ URL::asset('assets/fonts/material-icons/material-icons.woff2') }}" as="font" type="font/woff2" crossorigin>
    <link rel="preload" href="{{ URL::asset('assets/fonts/material-icons/material-icons-outlined.woff2') }}" as="font" type="font/woff2" crossorigin>

</head>

<body>
    <main class="main">
        <div class="main-inner">
            {{-- begain mob --}}
            <nav class="mob-main-mnu">
                <div class="mob-main-mnu-content">
                    <ul class="mob-main-mnu-list">
                        {{-- Home --}}
                        <li>
                            <a href="{{ url($dataFromBaseController['language'] . '/home') }}">{{ __('lang.home') }}</a>
                        </li>


                        {{-- production --}}
                        <li>
                            <a href="{{ url($dataFromBaseController['language'] . '/home/#production') }}">{{ __('lang.production') }}</a>
                        </li>

                        {{-- channels --}}
                        <li>
                            {{-- href="{{ url($dataFromBaseController['language'] . '/news') }}" --}}
                            <a href="{{ url($dataFromBaseController['language'] . '/channels') }}">{{ __('lang.channels') }}</a>
                        </li>

                        {{-- Contact us --}}
                        <li>
                            <a href="{{ url($dataFromBaseController['language'] . '/contact-us') }}">{{ __('lang.contactUs') }}</a>
                        </li>
                        {{-- about us --}}
                        <li>
                            <a href="{{ url($dataFromBaseController['language'] . '/about-us') }}">{{ __('lang.aboutUs') }}</a>
                        </li>
                    </ul>
                </div>
                <div class="mob-main-mnu-footer">
                    <ul class="mob-main-mnu-lang">
                        <li class=""><a href="{{ url('locale/en') }}"><span>En</span></a></li>
                        <li><a href="{{ url('locale/ar') }}"><span>Ar</span></a></li>
                    </ul>
                </div>
            </nav>
            <!-- End mobile main menu -->

            <!-- Begin header -->
            <header class="header">
                <!-- Begin header fixed -->
                <nav class="header-fixed">
                    <div class="container">
                        <div class="row flex-nowrap align-items-center justify-content-between">
                            <div class="col-auto d-block d-lg-none header-fixed-col">
                                <div class="main-mnu-btn">
                                    <span class="bar bar-1"></span>
                                    <span class="bar bar-2"></span>
                                    <span class="bar bar-3"></span>
                                    <span class="bar bar-4"></span>
                                </div>
                            </div>
                            <div class="col-auto header-fixed-col">
                                <!-- Begin logo -->
                                <a href="{{ url($dataFromBaseController['language'] . '/home') }}" class="logo" title="Business">
                                    <img src="{{ URL::asset('assets/img/spacetoon_original_logo.png') }}" alt="Business">
                                </a>
                                <!-- End logo -->
                            </div>
                            <div class="col-lg col-auto col-static header-fixed-col">
                                <div class="row flex-nowrap align-items-center justify-content-end">
                                    <div class="col-auto header-fixed-col d-none d-lg-block col-static">
                                        <!-- Begin main menu -->
                                        <nav class="main-mnu">
                                            <ul class="main-mnu-list">
                                                {{-- Home --}}
                                                <li class="menu-item-has-children">
                                                    <a href="{{ url($dataFromBaseController['language'] . '/home') }}" data-title="{{ __('lang.home') }}">
                                                        <span>{{ __('lang.home') }}</span>
                                                    </a>
                                                </li>

                                                {{-- production --}}
                                                <li class="menu-item-has-children">
                                                    <a href="{{ url($dataFromBaseController['language'] . '/home/#production') }}" data-title="{{ __('lang.production') }}">
                                                        <span>{{ __('lang.production') }}</span>
                                                    </a>
                                                </li>
                                                {{-- services --}}
                                                <li class="menu-item-has-children">
                                                    <a href="{{ url($dataFromBaseController['language'] . '/channels') }}" data-title="{{ __('lang.channels') }}">
                                                        <span>{{ __('lang.channels') }}</span>
                                                    </a>
                                                </li>
                                                {{-- Contact Us --}}
                                                <li class="menu-item-has-children">
                                                    <a href="{{ url($dataFromBaseController['language'] . '/contact-us') }}" data-title="{{ __('lang.contactUs') }}">
                                                        <span>{{ __('lang.contactUs') }}</span>
                                                    </a>
                                                </li>
                                                {{-- About us --}}
                                                <li class="menu-item-has-children">
                                                    <a href="{{ url($dataFromBaseController['language'] . '/about-us') }}" data-title="{{ __('lang.aboutUs') }}">
                                                        <span>{{ __('lang.aboutUs') }}</span>
                                                    </a>
                                                </li>
                                            </ul>
                                        </nav>
                                        <!-- End main menu -->
                                    </div>
                                    <div class="col-auto header-fixed-col col-static">
                                        <!-- Begin header actions -->
                                        <ul class="header-actions">
                                            <!-- Begin header languarge -->
                                            <li class="d-none d-lg-block">
                                                <div class="header-lang">
                                                    <div class="header-lang-current"><i class="material-icons md-22">language</i></div>
                                                    <ul class="header-lang-list">
                                                        <li><a href="{{ url('locale/en') }}" class="hover-link" data-lang="En" data-title="{{ __('lang.english') }}"><span>{{ __('lang.english') }}</span></a>
                                                        </li>
                                                        <li><a href="{{ url('locale/ar') }}" class="hover-link" data-lang="Ar" data-title="{{ __('lang.arabic') }}"><span>{{ __('lang.arabic') }}</span></a>
                                                        </li>
                                                    </ul>
                                                </div>
                                            </li>
                                            <!-- End header languarge -->
                                        </ul>
                                        <!-- End header actions -->
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </nav>
                <!-- End header fixed -->
            </header>
            <!-- End header -->
            @yield('content')
        </div>
        <!-- Begin footer -->
        <footer class="footer">
            @foreach ($dataFromBaseController['contacts'] as $contact)
            <ul class="footer-social-links">
                <li>
                    <a target="_blank" href={{ $contact->linkedIn }} title="LinkedIn">
                        <svg viewBox="0 0 448 512">
                            <use class="icon-svg" xlink:href="{{ URL::asset('assets/img/sprite.svg#linkedin-icon') }}">
                            </use>
                        </svg>
                    </a>
                </li>
                <li>
                    <a target="_blank" href={{ $contact->facebook }} title="Facebook">
                        <svg viewBox="0 0 320 512">
                            <use class="icon-svg" xlink:href="{{ URL::asset('assets/img/sprite.svg#facebook-icon') }}">
                            </use>
                        </svg>
                    </a>
                </li>
                <li>
                    <a target="_blank" href={{ $contact->youtube }} title="YouTube">
                        <svg viewBox="0 0 512 512">
                            <use class="icon-svg" xlink:href="{{ URL::asset('assets/img/sprite.svg#youtube-icon') }}">
                            </use>
                        </svg>
                    </a>
                </li>
                <li>
                    <a target="_blank" href={{ $contact->instagram }} title="Instagram">
                        <svg viewBox="0 0 448 512">
                            <use class="icon-svg" xlink:href="{{ URL::asset('assets/img/sprite.svg#instagram-icon') }}">
                            </use>
                        </svg>
                    </a>
                </li>
            </ul>
            @endforeach
            <div class="col-md-auto col-12 item">
                <div class="copyright">
                    {{ __('lang.title') }} {{ date('Y') }} | {{ __('lang.rights') }}
                </div>
            </div>
        </footer>
        <!-- End footer -->
    </main>

    <script src="{{ URL::asset('assets/libs/jquery/jquery.min.js') }}"></script>
    <script src="{{ URL::asset('assets/libs/lozad/lozad.min.js') }}"></script>
    <script src="{{ URL::asset('assets/libs/device/device.js') }}"></script>
    <script src="{{ URL::asset('assets/libs/ScrollToFixed/jquery-scrolltofixed-min.js') }}"></script>
    <script src="{{ URL::asset('assets/libs/spincrement/jquery.spincrement.min.js') }}"></script>
    <script src="{{ URL::asset('assets/libs/jquery-popup-overlay-gh-pages/jquery.popupoverlay.js') }}"></script>
    <script src="{{ URL::asset('assets/libs/jquery-validation-1.19.3/jquery.validate.min.js') }}"></script>
    <script src="{{ URL::asset('assets/libs/autosize-master/autosize.min.js') }}"></script>
    <script src="{{ URL::asset('assets/libs/flickity/flickity.pkgd.min.js') }}"></script>
    <script src="{{ URL::asset('assets/libs/flickity/flickity-imagesloaded.js') }}"></script>
    <script src="{{ URL::asset('assets/libs/flickity/bg-lazyload.js') }}"></script>
    <script src="{{ URL::asset('assets/libs/flickity/flickity-fade.js') }}"></script>
    <script src="{{ URL::asset('assets/libs/isotope/isotope.pkgd.min.js') }}"></script>
    <script src="{{ URL::asset('assets/libs/lightGallery/js/picturefill.min.js') }}"></script>
    <script src="{{ URL::asset('assets/libs/lightGallery/js/lightgallery-all.min.js') }}"></script>
    <script src="{{ URL::asset('assets/libs/lightGallery/js/jquery.mousewheel.min.js') }}"></script>
    <script src="{{ URL::asset('assets/libs/jquery-ui-range/jquery-ui.min.js') }}"></script>
    <script src="{{ URL::asset('assets/js/custom.js') }}"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
    {{-- {!! NoCaptcha::renderJs() !!} --}}

    {{-- @include('sweetalert::alert') --}}
</body>

</html>