@extends('layout')

@section('title', __('lang.contact'))
@section('keywords', __('seo_lang.contact_kw'))
@section('content')
<!-- Begin bread crumbs -->
<nav class="bread-crumbs">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <ul class="bread-crumbs-list">
                    <li>
                        <a href="{{ url($dataFromBaseController['language'] . '/home') }}">{{ __('lang.home') }}</a>
                        <i class="material-icons md-18">chevron_right</i>
                    </li>
                    <li><a href="{{ url($dataFromBaseController['language'] . '/contact-us') }}">{{ __('lang.contact') }}</a>
                    </li>
                </ul>
            </div>
        </div>
    </div>
</nav>
<!-- End bread crumbs -->

<!-- Begin Content -->
<div class="section">
    @foreach ($dataFromBaseController['contacts'] as $contact)
    <div class="container">
        <div class="col-12">
            <div class="home-heading section-heading heading-center">
                <span>{{ $contact->{$dataFromBaseController['language'] . '_title'} }}</span>
                <p>{{ $contact->{$dataFromBaseController['language'] . '_subtitle'} }}</p>
            </div>
        </div>
    </div>

    <div class="container form-heading-center">
        <div class="row content-items d-flex justify-content-center text-center">
            <div class="col-md-4 col-12 content-item">
                <div class="contacts-info-item item-style">
                    <div class="contacts-info-item-ico">
                        <i class="material-icons md-60">location_on</i>
                    </div>
                    <div class="contacts-info-item-content">
                        <a href="https://www.google.com/maps/place/4730+Crystal+Springs+Dr,+Los+Angeles,+CA+90027,+%D0%A1%D0%A8%D0%90/data=!4m2!3m1!1s0x80c2c08ea296b841:0x5030fc6064b8e8d1?sa=X&ved=2ahUKEwijmtvUqZvjAhXjkIsKHYNsDswQ8gEwAHoECAkQAQ">
                            {{ $contact->{$dataFromBaseController['language'] . '_address'} }}
                        </a>
                        <p>{{ $contact->{$dataFromBaseController['language'] . '_subtitle_address'} }}</p>
                    </div>
                </div>
            </div>
            <div class="col-md-4 col-12 content-item">
                <div class="contacts-info-item item-style">
                    <div class="contacts-info-item-ico">
                        <i class="material-icons md-60 footer-contact-email">email</i>
                    </div>
                    <div class="contacts-info-item-content">
                        <div>
                            <a href="{{ $contact->first_email }}">{{ $contact->first_email }}</a>
                        </div>
                        <div>
                            <a href="{{ $contact->second_email }}">{{ $contact->second_email }}</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @endforeach
</div>
<!-- End Content -->
@endsection