@extends('layout')

@section('title', __('lang.aboutUs'))
@section('keywords', __('seo_lang.contact_kw'))
@section('content')

<!-- Begin bread crumbs -->
<nav class="bread-crumbs">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <ul class="bread-crumbs-list">
                    <li>
                        <a href="{{ url($dataFromBaseController['language'] . '/home') }}">{{ __('lang.home') }}</a>
                        <i class="material-icons md-18">chevron_right</i>
                    </li>
                    <li><a href="{{ url($dataFromBaseController['language'] . '/about-us') }}">{{ __('lang.aboutUs') }}</a>
                    </li>
                </ul>
            </div>
        </div>
    </div>
</nav>
<!-- End bread crumbs -->

<main class="main">
    <!-- Begin Content -->
    <section id="banner" class="banner">
        @foreach ($dataFromBaseController['infos'] as $info)
        <div class="w-100">
            <img src={{ url('storage/' . $info->about_banner_image) }} alt="" class="topArch w-100">
        </div>
        <div class="about-content container">
            <div class="contact-heading section-heading heading-center">
                <h1>{{ $info->{$dataFromBaseController['language'] . '_about_title'} }}</h1>
            </div>
            <p>{{ $info->{$dataFromBaseController['language'] . '_about_description'} }}</p>
        </div>
        @endforeach
    </section>
    <!-- End Content -->
</main>
@endsection