<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('posters', function (Blueprint $table) {
            $table->id();
            $table->string('cover_image')->collation('utf16_unicode_ci');
            $table->string('ar_title')->collation('utf16_unicode_ci');
            $table->string('en_title')->collation('utf16_unicode_ci');
            $table->string('ar_bref')->collation('utf16_unicode_ci');
            $table->string('en_bref')->collation('utf16_unicode_ci');
            $table->text('home_banner_video')->collation('utf16_unicode_ci');
            $table->string('episodes_number')->collation('utf16_unicode_ci');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('posters');
    }
};
