<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('infos', function (Blueprint $table) {
            $table->id();
            $table->text('home_banner_image')->collation('utf16_unicode_ci')->nullable();
            $table->text('home_banner_video')->collation('utf16_unicode_ci')->nullable();
            $table->text('about_banner_image')->collation('utf16_unicode_ci');
            $table->string('ar_about_title')->collation('utf16_unicode_ci');
            $table->string('en_about_title')->collation('utf16_unicode_ci');
            $table->string('ar_about_description')->collation('utf16_unicode_ci');
            $table->string('en_about_description')->collation('utf16_unicode_ci');
            $table->string('ar_address')->collation('utf16_unicode_ci');
            $table->string('en_address')->collation('utf16_unicode_ci');
            $table->string('telephone')->collation('utf16_unicode_ci');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('infos');
    }
};
