<?php $__env->startSection('title', __('lang.channels')); ?>
<?php $__env->startSection('keywords', __('seo_lang.contact_kw')); ?>
<?php $__env->startSection('content'); ?>

<?php
function formatViews($views)
{
    if ($views >= 1000000000) {
        return round($views / 1000000000, 1) . 'B';
    } elseif ($views >= 1000000) {
        return round($views / 1000000, 1) . 'M';
    } elseif ($views >= 1000) {
        return round($views / 1000) . 'k';
    } else {
        return $views;
    }
}
?>
<!-- Begin bread crumbs -->
<nav class="bread-crumbs">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <ul class="bread-crumbs-list">
                    <li>
                        <a href="<?php echo e(url($dataFromBaseController['language'] . '/home')); ?>"><?php echo e(__('lang.home')); ?></a>
                        <i class="material-icons md-18">chevron_right</i>
                    </li>
                    <li><a href="<?php echo e(url($dataFromBaseController['language'] . '/channels')); ?>"><?php echo e(__('lang.channels')); ?></a>
                    </li>
                </ul>
            </div>
        </div>
    </div>
</nav>
<!-- End bread crumbs -->


<main class="main">
    <!-- Begin Content -->
    <div class="section">
        <div class="container">
            <div class="col-12">
                <div class="section-heading heading-center channel">
                    <h1><?php echo e(__('lang.channels')); ?></h1>
                    <?php $__currentLoopData = $dataFromBaseController['infos']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $info): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <span><?php echo e($info->{$dataFromBaseController['language'] . '_channel_title'}); ?></span>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
            <div class="row text-center">
                <?php $__currentLoopData = $dataFromBaseController['channels']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $channel): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="channel-item col-xl-4 col-lg-6 col-md-6 col-sm-12">
                    <div class="d-flex align-items-center justify-content-center">
                        <div class="channel-img-container">
                            <a href="<?php echo e($channel->url); ?>">
                                <img class="channel-img" src="<?php echo e(url('storage/' . $channel->logo)); ?>" alt="">
                            </a>
                        </div>
                    </div>
                    <div class="channel-views-container">
                        <span class="channel-views">
                            <?php echo e(formatViews($channel->number_of_views)); ?>

                            <?php echo e($channel->views_or_subscribers === 'option1' ? __('lang.views') : ($channel->views_or_subscribers === 'option2' ? __('lang.subscribers') : __('lang.users'))); ?>

                        </span>
                    </div>
                    <p class="channel-brief"><?php echo e($channel->{$dataFromBaseController['language'] . '_bref'}); ?></p>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>
    <!-- End Content -->
</main>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/stgnet/public_html/ni321/spacetoon_originals/resources/views/channel.blade.php ENDPATH**/ ?>