@extends('layout')

@section('title', __('lang.home'))
@section('keywords', __('seo_lang.home_kw'))
@section('content')

<main class="main">
    <div class="main-inner">
        <!-- Begin intro -->
        <!-- Banner -->
        <section id="banner" class="banner">
            @foreach ($dataFromBaseController['infos'] as $info)
            <div class="w-100">
                @if ($info->home_banner_video != "[]")
                <video src=" {{ url('storage/' . json_decode($info->home_banner_video)[count(json_decode($info->home_banner_video)) - 1]->download_link) }}" autoplay muted loop></video>
                @else
                <!--<div class="news-post-img">-->
                <img src={{ url('storage/' . $info->home_banner_image) }} alt="" class="topArch w-100">
                <!--</div>-->
                @endif
            </div>
            @endforeach
        </section>
        <!-- End intro -->

        <!-- Begin production -->
        <section id="production" class="section section-bgc">
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <div class="home-heading section-heading heading-center">
                            @foreach ($dataFromBaseController['infos'] as $info)
                            <span>{{ $info->{$dataFromBaseController['language'] . '_production_title'} }}</span>
                            @endforeach
                        </div>
                    </div>
                </div>
                <div class="row no-gutters">
                    @foreach ($dataFromBaseController['posters'] as $poster)
                    <div class="poster col-xl-4 col-lg-6 col-md-6 col-sm-12">

                        <div class="image-container">
                            <a href="{{ url('/poster/' . $poster->{$dataFromBaseController['language'] . '_slug'}) }}">
                                <img class="img-fluid" src="{{ url('storage/' . $poster->poster_image) }}" alt="">
                                <div class="overlay">
                                    <div class="overlay-content">
                                        <span>{{ $poster->{$dataFromBaseController['language'] . '_title'} }}</span>
                                        <p>{{ $poster->{$dataFromBaseController['language'] . '_subtitle'} }}</p>
                                    </div>
                                </div>
                            </a>
                        </div>

                    </div>
                    @endforeach
                </div>
            </div>
        </section>
        <!-- End production-->
    </div>
</main>
@endsection