@extends('layout')

@section('title', __('lang.channels'))
@section('keywords', __('seo_lang.contact_kw'))
@section('content')

<?php
function formatViews($views)
{
    if ($views >= 1000000000) {
        return round($views / 1000000000, 1) . 'B';
    } elseif ($views >= 1000000) {
        return round($views / 1000000, 1) . 'M';
    } elseif ($views >= 1000) {
        return round($views / 1000) . 'k';
    } else {
        return $views;
    }
}
?>
<!-- Begin bread crumbs -->
<nav class="bread-crumbs">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <ul class="bread-crumbs-list">
                    <li>
                        <a href="{{ url($dataFromBaseController['language'] . '/home') }}">{{ __('lang.home') }}</a>
                        <i class="material-icons md-18">chevron_right</i>
                    </li>
                    <li><a href="{{ url($dataFromBaseController['language'] . '/channels') }}">{{ __('lang.channels') }}</a>
                    </li>
                </ul>
            </div>
        </div>
    </div>
</nav>
<!-- End bread crumbs -->


<main class="main">
    <!-- Begin Content -->
    <div class="section">
        <div class="container">
            <div class="col-12">
                <div class="section-heading heading-center channel">
                    <h1>{{ __('lang.channels') }}</h1>
                    @foreach ($dataFromBaseController['infos'] as $info)
                    <span>{{ $info->{$dataFromBaseController['language'] . '_channel_title'} }}</span>
                    @endforeach
                </div>
            </div>
            <div class="row text-center">
                @foreach ($dataFromBaseController['channels'] as $channel)
                <div class="channel-item col-xl-4 col-lg-6 col-md-6 col-sm-12">
                    <div class="d-flex align-items-center justify-content-center">
                        <div class="channel-img-container">
                            <a href="{{ $channel->url }}">
                                <img class="channel-img" src="{{ url('storage/' . $channel->logo) }}" alt="">
                            </a>
                        </div>
                    </div>
                    <div class="channel-views-container">
                        <span class="channel-views">
                            {{ formatViews($channel->number_of_views) }}
                            {{ $channel->views_or_subscribers === 'option1' ? __('lang.views') : ($channel->views_or_subscribers === 'option2' ? __('lang.subscribers') : __('lang.users')) }}
                        </span>
                    </div>
                    <p class="channel-brief">{{ $channel->{$dataFromBaseController['language'] . '_bref'} }}</p>
                </div>
                @endforeach
            </div>
        </div>
    </div>
    <!-- End Content -->
</main>
@endsection