<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

class Poster extends Model
{
    use HasFactory;
    protected $fillable = [
        'poster_image',
        'ar_title',
        'en_title',
        'ar_subtitle',
        'en_subtitle',
        'ar_bref',
        'en_bref',
        'poster_videoo',
        'ar_slug',
        'en_slug',
        'ar_subtitle',
        'en_subtitle',
        'ar_production_year',
        'en_production_year',
        'production_type',
        'number_of_seasons',
        'number_of_episodes_seasons',
        'ar_episode_duration',
        'en_episode_duration',
        'ar_partnering',
        'en_partnering',
        'ar_age_group',
        'en_age_group'
    ];


    public static function boot()
    {
        parent::boot();

        static::saving(function ($model) {
            $model->ar_slug = $model->ar_title;
            $model->en_slug = $model->en_title;
        });
    }
}
