<?php

namespace App\Http\Controllers;

use App\Models\Channel;
use App\Models\Contact;
use App\Models\Poster;
use App\Models\Info;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Routing\Controller as BaseController;

class Controller extends BaseController
{
    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;
    protected function getData()
    {
        return [
            'posters' => Poster::OrderBy('priority','desc')->get(),
            'channels' => Channel::all(),
            'contacts' => Contact::all(),
            'infos' => Info::all(),
            'language' => app()->getLocale(),
        ];
    }
}
